<?php
session_start();
include "db.php";

// Define fuso horário do PHP
date_default_timezone_set('America/Sao_Paulo');

// Funções auxiliares
function esc($v)
{
    return htmlspecialchars($v ?? '', ENT_QUOTES, 'UTF-8');
}
function requireLogin()
{
    if (empty($_SESSION['user_id'])) {
        header('Location: login.php');
        exit;
    }
}
function formatarData($datetime)
{
    if (!$datetime) return '—';
    return date('d/m/Y H:i', strtotime($datetime));
}

// Usuário logado
$user_id = $_SESSION['user_id'] ?? null;
$is_admin = $_SESSION['is_admin'] ?? 0;
requireLogin();

$msg = "";
$partida_id = isset($_GET['partida_id']) ? (int)$_GET['partida_id'] : null;

// --- Processa aposta normal ---
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['acao']) && $_POST['acao'] === 'salvar_aposta') {
    $partida_id = (int)$_POST['partida_id'];
    $gols_casa = (int)$_POST['gols_casa'];
    $gols_fora = (int)$_POST['gols_fora'];

    $stmt = $pdo->prepare("SELECT * FROM partidas WHERE id = ?");
    $stmt->execute([$partida_id]);
    $p = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$p) {
        $msg = "<div class='alert alert--err'>Partida inválida.</div>";
    } elseif (strtotime($p['fechamento']) <= time()) {
        $msg = "<div class='alert alert--err'>O prazo para apostar já expirou.</div>";
    } else {
        $stmt = $pdo->prepare("SELECT id FROM apostas WHERE usuario_id = ? AND partida_id = ?");
        $stmt->execute([$user_id, $partida_id]);
        $ex = $stmt->fetchColumn();

        if ($ex) {
            $pdo->prepare("UPDATE apostas SET gols_casa=?, gols_fora=? WHERE id=?")
                ->execute([$gols_casa, $gols_fora, $ex]);
            $msg = "<div class='alert alert--ok'>✅ Palpite atualizado.</div>";
        } else {
            $pdo->prepare("INSERT INTO apostas (usuario_id, partida_id, gols_casa, gols_fora) VALUES (?, ?, ?, ?)")
                ->execute([$user_id, $partida_id, $gols_casa, $gols_fora]);
            $msg = "<div class='alert alert--ok'>✅ Palpite registrado.</div>";
        }
    }
}

// --- Processa edição do confronto (ADMIN) ---
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['acao']) && $_POST['acao'] === 'editar_confronto' && $is_admin) {
    $partida_id = (int)$_POST['partida_id'];
    $time_casa  = trim($_POST['time_casa']);
    $time_fora  = trim($_POST['time_fora']);
    $data_jogo  = $_POST['data_jogo'];
    $fechamento = $_POST['fechamento'];

    $pdo->prepare("UPDATE partidas SET time_casa=?, time_fora=?, data_jogo=?, fechamento=? WHERE id=?")
        ->execute([$time_casa, $time_fora, $data_jogo, $fechamento, $partida_id]);

    $msg = "<div class='alert alert--ok'>✏️ Confronto atualizado com sucesso.</div>";
}

// Lista partidas
$stmt = $pdo->prepare("SELECT * FROM partidas ORDER BY data_jogo DESC");
$stmt->execute();
$partidas = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Se veio partida_id
$partida = null;
$aposta_existente = null;
if ($partida_id) {
    $stmt = $pdo->prepare("SELECT * FROM partidas WHERE id = ?");
    $stmt->execute([$partida_id]);
    $partida = $stmt->fetch(PDO::FETCH_ASSOC);

    $stmt = $pdo->prepare("SELECT * FROM apostas WHERE usuario_id = ? AND partida_id = ?");
    $stmt->execute([$user_id, $partida_id]);
    $aposta_existente = $stmt->fetch(PDO::FETCH_ASSOC);
}
?>
<!DOCTYPE html>
<html lang="pt-br">

<head>
    <meta charset="utf-8">
    <title>Apostar — GreNal</title>
    <link rel="stylesheet" href="css/style.css">
</head>

<body>
    <div class="container page--apostar">
        <div class="page-header">
            <div class="page-title">
                <h1>Dar Palpite</h1>
                <p>Aposte ou edite seu palpite antes do fechamento</p>
            </div>
            <div class="top-actions">
                <a class="nav-link" href="index.php">🏠 Início</a>
            </div>
        </div>

        <?= $msg ?>

        <?php if ($partida):
            $data_fmt = formatarData($partida['data_jogo']);
            $fech = formatarData($partida['fechamento']);
            $closed = strtotime($partida['fechamento']) <= time();
        ?>
            <div class="match-card">
                <div class="match-info">
                    <div class="team">
                        <div class="name"><?= esc($partida['time_casa']) ?></div>
                    </div>
                    <div class="vs">
                        <div class="match-date"><?= $data_fmt ?></div>
                        <div class="helper small muted">Fechamento: <?= $fech ?></div>
                    </div>
                    <div class="team">
                        <div class="name"><?= esc($partida['time_fora']) ?></div>
                    </div>
                </div>
            </div>

            <?php if (!$closed): ?>
                <!-- Form aposta -->
                <form method="post">
                    <input type="hidden" name="acao" value="salvar_aposta">
                    <input type="hidden" name="partida_id" value="<?= (int)$partida['id'] ?>">
                    <div class="form-grid">
                        <div class="form-field">
                            <label>Gols <?= esc($partida['time_casa']) ?></label>
                            <input type="number" name="gols_casa" class="input-score" min="0" required value="<?= $aposta_existente['gols_casa'] ?? '' ?>">
                        </div>
                        <div class="form-field">
                            <label>Gols <?= esc($partida['time_fora']) ?></label>
                            <input type="number" name="gols_fora" class="input-score" min="0" required value="<?= $aposta_existente['gols_fora'] ?? '' ?>">
                        </div>
                    </div>
                    <button type="submit" class="btn btn-primary">Salvar Palpite</button>
                </form>
            <?php else: ?>
                <div class="alert alert--err">O período de apostas já foi encerrado.</div>
            <?php endif; ?>

            <?php if ($is_admin): ?>
                <hr>
                <h3>✏️ Editar Confronto (Admin)</h3>
                <form method="post">
                    <input type="hidden" name="acao" value="editar_confronto">
                    <input type="hidden" name="partida_id" value="<?= (int)$partida['id'] ?>">
                    <div class="form-grid">
                        <div class="form-field">
                            <label>Time Casa</label>
                            <input type="text" name="time_casa" required value="<?= esc($partida['time_casa']) ?>">
                        </div>
                        <div class="form-field">
                            <label>Time Fora</label>
                            <input type="text" name="time_fora" required value="<?= esc($partida['time_fora']) ?>">
                        </div>
                        <div class="form-field">
                            <label>Data do Jogo</label>
                            <input type="datetime-local" id="data-jogo" name="data_jogo" required value="<?= date('Y-m-d\TH:i', strtotime($partida['data_jogo'])) ?>">
                        </div>
                        <div class="form-field">
                            <label>Fechamento das Apostas</label>
                            <input type="datetime-local" id="fechamento-aposta" name="fechamento" required value="<?= date('Y-m-d\TH:i', strtotime($partida['fechamento'])) ?>">
                        </div>
                    </div>
                    <button type="submit" class="btn btn-warning">⚡ Atualizar Confronto</button>
                </form>
            <?php endif; ?>

        <?php else: ?>
            <h3>Partidas cadastradas</h3>
            <?php if (count($partidas) === 0): ?>
                <div class="alert alert--err">Ainda não há partidas cadastradas.</div>
            <?php else: ?>
                <?php foreach ($partidas as $p):
                    $data_fmt = formatarData($p['data_jogo']);
                    $fech = formatarData($p['fechamento']);
                    $closed = strtotime($p['fechamento']) <= time();
                ?>
                    <div class="match-card">
                        <div class="match-info">
                            <div class="team">
                                <div class="name"><?= esc($p['time_casa']) ?></div>
                            </div>
                            <div class="vs">
                                <div class="match-date"><?= $data_fmt ?></div>
                                <div class="helper small muted">Fechamento: <?= $fech ?></div>
                            </div>
                            <div class="team">
                                <div class="name"><?= esc($p['time_fora']) ?></div>
                            </div>
                        </div>
                        <div style="display:flex;flex-direction:column;gap:8px;align-items:flex-end">
                            <?php if (!$closed): ?>
                                <a class="nav-link" href="apostas.php?partida_id=<?= $p['id'] ?>">🎯 Apostar / Editar</a>
                            <?php else: ?>
                                <span class="muted small">Encerrada</span>
                            <?php endif; ?>
                        </div>
                    </div>
                <?php endforeach; ?>
            <?php endif; ?>
        <?php endif; ?>
    </div>
</body>

</html>