<?php
session_start();
include "db.php";

// Define fuso horário do PHP
date_default_timezone_set('America/Sao_Paulo');

// Helpers
function esc($v)
{
    return htmlspecialchars($v ?? '', ENT_QUOTES, 'UTF-8');
}
function isLogged()
{
    return !empty($_SESSION['user_id']);
}
function getUserId()
{
    return $_SESSION['user_id'] ?? null;
}
function isAdmin($pdo)
{
    if (!isLogged()) return false;
    $stmt = $pdo->prepare("SELECT is_admin FROM usuarios WHERE id = ?");
    $stmt->execute([getUserId()]);
    $r = $stmt->fetch(PDO::FETCH_ASSOC);
    return $r && !empty($r['is_admin']);
}

// Ranking: soma de pontos por usuário
$ranking = $pdo->query("
    SELECT u.id, u.nome, COALESCE(SUM(a.pontos),0) AS total
    FROM usuarios u
    LEFT JOIN apostas a ON a.usuario_id = u.id
    GROUP BY u.id
    ORDER BY total DESC, u.nome ASC
")->fetchAll(PDO::FETCH_ASSOC);

?>
<!DOCTYPE html>
<html lang="pt-br">

<head>
    <meta charset="utf-8">
    <title>Dashboard - Apostas GreNal</title>
    <link rel="stylesheet" href="css/style.css">
</head>

<body>
    <div class="container page--home">
        <div class="page-header">
            <div class="page-title">
                <h1>Dashboard — Apostas GreNal</h1>
                <p>Ranking, próximas partidas e suas apostas</p>
            </div>
            <div class="top-actions">
                <?php if (isLogged()): ?>
                    <span class="small muted">Olá, <?= esc($_SESSION['user_nome']) ?></span>
                    <a class="nav-link" href="apostas.php">🎯 Apostar</a>
                    <a class="nav-link" href="ver_apostas.php">🔍 Ver Apostas</a>
                    <?php if (isAdmin($pdo)): ?>
                        <a class="nav-link" href="partidas.php">⚙️ Nova Partida</a>
                        <a class="nav-link" href="pontuar.php">🏁 Resultado</a>
                    <?php endif; ?>
                    <a class="nav-link" href="login.php">🚪 Sair</a>
                <?php else: ?>
                    <a class="nav-link" href="login.php">🔐 Entrar</a>
                    <a class="nav-link" href="register.php">✍️ Registrar</a>

                <?php endif; ?>
            </div>
        </div>

        <!-- Ranking -->
        <h2 style="margin-bottom:8px;">🏆 Ranking</h2>
        <div class="table-wrap" style="margin-bottom:16px;">
            <table>
                <thead>
                    <tr>
                        <th>#</th>
                        <th>Apostador</th>
                        <th>Pontos</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $pos = 1;
                    foreach ($ranking as $r): ?>
                        <tr>
                            <td><span class="rank-badge"><?= $pos++ ?></span></td>
                            <td class="name-strong"><?= esc($r['nome']) ?></td>
                            <td class="points"><?= (int)$r['total'] ?></td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    </div>
</body>

</html>