<?php
session_start();
include "db.php";

// Define fuso horário do PHP
date_default_timezone_set('America/Sao_Paulo');

$msg = "";
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $email = trim($_POST['email']);
    $senha = $_POST['senha'];

    $stmt = $pdo->prepare("SELECT * FROM usuarios WHERE email = ?");
    $stmt->execute([$email]);
    $user = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($user && password_verify($senha, $user['senha'])) {
        $_SESSION['user_id'] = $user['id'];
        $_SESSION['user_nome'] = $user['nome'];
        $_SESSION['is_admin'] = $user['is_admin'] ?? 0;
        header("Location: index.php");
        exit;
    } else {
        $msg = "<div class='alert alert--err'>❌ Email ou senha incorretos.</div>";
    }
}
?>
<!DOCTYPE html>
<html lang="pt-br">

<head>
    <meta charset="utf-8">
    <title>Login — Apostas GreNal</title>
    <link rel="stylesheet" href="css/style.css">
    <style>
        /* estilos extras só para login */
        body {
            display: flex;
            align-items: center;
            justify-content: center;
            min-height: 100vh;
            background: linear-gradient(135deg, #1d3557, #457b9d);
            font-family: 'Segoe UI', sans-serif;
        }

        .login-card {
            background: #fff;
            padding: 2rem;
            border-radius: 16px;
            box-shadow: 0 8px 24px rgba(0, 0, 0, 0.2);
            width: 100%;
            max-width: 380px;
            animation: fadeIn 0.8s ease;
        }

        .login-card h1 {
            text-align: center;
            margin-bottom: 0.5rem;
            font-size: 1.8rem;
            color: #1d3557;
        }

        .login-card p {
            text-align: center;
            margin-bottom: 1.5rem;
            color: #6c757d;
            font-size: 0.9rem;
        }

        .login-card .form-field {
            margin-bottom: 1.2rem;
        }

        .login-card label {
            font-size: 0.85rem;
            color: #333;
            display: block;
            margin-bottom: 0.3rem;
        }

        .login-card input {
            width: 100%;
            padding: 0.8rem;
            border-radius: 8px;
            border: 1px solid #ccc;
            font-size: 1rem;
        }

        .login-card input:focus {
            outline: none;
            border-color: #457b9d;
            box-shadow: 0 0 0 3px rgba(69, 123, 157, 0.2);
        }

        .login-card button {
            width: 100%;
            padding: 0.9rem;
            border: none;
            border-radius: 8px;
            background: #1d3557;
            color: #fff;
            font-size: 1rem;
            font-weight: bold;
            cursor: pointer;
            transition: background 0.3s;
        }

        .login-card button:hover {
            background: #457b9d;
        }

        .login-footer {
            text-align: center;
            margin-top: 1rem;
            font-size: 0.9rem;
        }

        .login-footer a {
            color: #1d3557;
            font-weight: bold;
            text-decoration: none;
        }

        .login-footer a:hover {
            text-decoration: underline;
        }

        @keyframes fadeIn {
            from {
                opacity: 0;
                transform: translateY(-20px);
            }

            to {
                opacity: 1;
                transform: translateY(0);
            }
        }
    </style>
</head>

<body>
    <div class="login-card">
        <h1>🔐 Login</h1>
        <p>Entre para participar das apostas</p>

        <?= $msg ?>

        <form method="post">
            <div class="form-field">
                <label for="email">E-mail</label>
                <input type="email" name="email" id="email" required placeholder="seu@email.com">
            </div>
            <div class="form-field">
                <label for="senha">Senha</label>
                <input type="password" name="senha" id="senha" required placeholder="••••••••">
            </div>
            <button type="submit">Entrar</button>
        </form>

        <div class="login-footer">
            <p>Não tem conta? <a href="register.php">Registrar-se</a></p>
        </div>
    </div>
</body>

</html>