<?php
session_start();
include "db.php";
// Define fuso horário do PHP
date_default_timezone_set('America/Sao_Paulo');

// Funções auxiliares
function esc($v)
{
    return htmlspecialchars($v ?? '', ENT_QUOTES, 'UTF-8');
}
function requireAdmin($pdo)
{
    if (empty($_SESSION['user_id'])) {
        header('Location: login.php');
        exit;
    }
    $stmt = $pdo->prepare("SELECT is_admin FROM usuarios WHERE id = ?");
    $stmt->execute([$_SESSION['user_id']]);
    $r = $stmt->fetch(PDO::FETCH_ASSOC);
    if (!($r && !empty($r['is_admin']))) {
        echo "<div class='container'><div class='alert alert--err'>Acesso negado. Admin necessário.</div></div>";
        exit;
    }
}
requireAdmin($pdo);

$msg = "";
$editando = false;
$partida_editar = null;

// Verifica se veio ?editar=ID
if (isset($_GET['editar'])) {
    $editando = true;
    $id = (int)$_GET['editar'];
    $stmt = $pdo->prepare("SELECT * FROM partidas WHERE id=?");
    $stmt->execute([$id]);
    $partida_editar = $stmt->fetch(PDO::FETCH_ASSOC);
}

// Processar formulário
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $time1 = trim($_POST['time1']);
    $time2 = trim($_POST['time2']);
    $data_jogo = $_POST['data_jogo'];
    $fechamento = $_POST['fechamento'];
    $id = $_POST['id'] ?? null;

    if ($time1 === '' || $time2 === '' || $data_jogo === '' || $fechamento === '') {
        $msg = "<div class='alert alert--err'>⚠️ Preencha todos os campos.</div>";
    } else {
        $data_jogo_sql = str_replace('T', ' ', $data_jogo);
        $fechamento_sql = str_replace('T', ' ', $fechamento);

        if ($id) {
            // Atualizar
            $stmt = $pdo->prepare("UPDATE partidas SET time_casa=?, time_fora=?, data_jogo=?, fechamento=? WHERE id=?");
            $stmt->execute([$time1, $time2, $data_jogo_sql, $fechamento_sql, $id]);
            $msg = "<div class='alert alert--ok'>✅ Confronto atualizado!</div>";
        } else {
            // Inserir novo
            $stmt = $pdo->prepare("INSERT INTO partidas (time_casa, time_fora, data_jogo, fechamento) VALUES (?, ?, ?, ?)");
            $stmt->execute([$time1, $time2, $data_jogo_sql, $fechamento_sql]);
            $msg = "<div class='alert alert--ok'>✅ Confronto cadastrado!</div>";
        }
    }
}

// listar confrontos existentes
$partidas = $pdo->query("SELECT * FROM partidas ORDER BY data_jogo DESC")->fetchAll(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html lang="pt-br">

<head>
    <meta charset="utf-8">
    <title>Cadastrar Confrontos — Admin</title>
    <link rel="stylesheet" href="css/style.css">
    <style>
        body {
            display: flex;
            justify-content: center;
            align-items: flex-start;
            min-height: 100vh;
            background: linear-gradient(135deg, #1d3557, #457b9d);
            font-family: 'Segoe UI', sans-serif;
            padding-top: 40px;
        }

        .card {
            background: #fff;
            border-radius: 16px;
            padding: 2rem;
            width: 100%;
            max-width: 500px;
            box-shadow: 0 8px 24px rgba(0, 0, 0, 0.2);
        }

        .card h1 {
            text-align: center;
            color: #1d3557;
            margin-bottom: 1rem;
        }

        .form-field {
            margin-bottom: 1rem;
        }

        label {
            display: block;
            font-size: 0.85rem;
            margin-bottom: 0.3rem;
            color: #333;
        }

        input {
            width: 100%;
            padding: 0.8rem;
            border-radius: 8px;
            border: 1px solid #ccc;
            font-size: 1rem;
        }

        input:focus {
            outline: none;
            border-color: #457b9d;
            box-shadow: 0 0 0 3px rgba(69, 123, 157, 0.2);
        }

        button {
            width: 100%;
            padding: 0.9rem;
            border: none;
            border-radius: 8px;
            background: #1d3557;
            color: #fff;
            font-weight: bold;
            font-size: 1rem;
            cursor: pointer;
            transition: background 0.3s;
        }

        button:hover {
            background: #457b9d;
        }

        .match-list {
            margin-top: 2rem;
        }

        .match-item {
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 0.5rem 0.8rem;
            border-bottom: 1px solid #eee;
        }

        .match-item span {
            font-weight: bold;
        }

        .top-actions {
            text-align: center;
            margin-bottom: 1rem;
        }

        .top-actions a {
            display: inline-block;
            color: #1d3557;
            font-weight: bold;
            text-decoration: none;
            margin: 0 0.5rem;
        }

        .top-actions a:hover {
            text-decoration: underline;
        }

        .helper {
            font-size: 0.8rem;
            color: #555;
            margin-top: -0.5rem;
            margin-bottom: 0.5rem;
        }

        .btn-edit {
            color: #1d3557;
            font-size: 0.85rem;
            text-decoration: none;
        }

        .btn-edit:hover {
            text-decoration: underline;
        }
    </style>
</head>

<body>
    <div class="card">
        <div class="top-actions">
            <a href="index.php">🏠 Início</a>
        </div>
        <h1><?= $editando ? "✏️ Editar Confronto" : "📋 Cadastrar Confronto" ?></h1>

        <?= $msg ?>

        <form method="post">
            <input type="hidden" name="id" value="<?= esc($partida_editar['id'] ?? '') ?>">
            <div class="form-field">
                <label>Time 1</label>
                <input type="text" name="time1" required placeholder="Nome do time 1" value="<?= esc($partida_editar['time_casa'] ?? '') ?>">
            </div>
            <div class="form-field">
                <label>Time 2</label>
                <input type="text" name="time2" required placeholder="Nome do time 2" value="<?= esc($partida_editar['time_fora'] ?? '') ?>">
            </div>
            <div class="form-field">
                <label>Data e horário da partida</label>
                <input type="datetime-local" name="data_jogo" required value="<?= isset($partida_editar['data_jogo']) ? date('Y-m-d\TH:i', strtotime($partida_editar['data_jogo'])) : '' ?>">
                <div class="helper">Fuso horário: Brasília (GMT-3)</div>
            </div>
            <div class="form-field">
                <label>Fechamento das apostas</label>
                <input type="datetime-local" name="fechamento" required value="<?= isset($partida_editar['fechamento']) ? date('Y-m-d\TH:i', strtotime($partida_editar['fechamento'])) : '' ?>">
                <div class="helper">Fuso horário: Brasília (GMT-3)</div>
            </div>
            <button type="submit"><?= $editando ? "Salvar Alterações" : "Cadastrar Confronto" ?></button>
        </form>
    </div>
</body>

</html>