<?php
session_start();
include "db.php";

// Define fuso horário do PHP
date_default_timezone_set('America/Sao_Paulo');

function esc($v)
{
    return htmlspecialchars($v ?? '', ENT_QUOTES, 'UTF-8');
}

function requireAdmin($pdo)
{
    if (empty($_SESSION['user_id'])) {
        header('Location: login.php');
        exit;
    }
    $stmt = $pdo->prepare("SELECT is_admin FROM usuarios WHERE id = ?");
    $stmt->execute([$_SESSION['user_id']]);
    $r = $stmt->fetch(PDO::FETCH_ASSOC);
    if (!($r && !empty($r['is_admin']))) {
        echo "<div class='container'><div class='alert alert--err'>Acesso negado. É necessário ser administrador.</div></div>";
        exit;
    }
}
requireAdmin($pdo);

$msg = "";

// quando for submeter o resultado
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $partida_id = (int)$_POST['partida_id'];
    $gols_c = (int)$_POST['gols_casa'];
    $gols_f = (int)$_POST['gols_fora'];

    // atualizar partida
    $pdo->prepare("UPDATE partidas SET gols_casa = ?, gols_fora = ? WHERE id = ?")
        ->execute([$gols_c, $gols_f, $partida_id]);

    // calcular pontos para cada aposta dessa partida
    $stmt = $pdo->prepare("SELECT * FROM apostas WHERE partida_id = ?");
    $stmt->execute([$partida_id]);
    $apostas = $stmt->fetchAll(PDO::FETCH_ASSOC);

    foreach ($apostas as $a) {
        $pontos = 0;
        // pontuação somente para acerto do placar exato
        if ($a['gols_casa'] == $gols_c && $a['gols_fora'] == $gols_f) {
            $pontos = 1;
        } else {
            $pontos = 0;
        }
        $pdo->prepare("UPDATE apostas SET pontos = ? WHERE id = ?")->execute([$pontos, $a['id']]);
    }

    $msg = "<div class='alert alert--ok'>✅ Resultado salvo e pontos atualizados para a partida.</div>";
}

// listar partidas para pontuar
$partidas = $pdo->query("SELECT * FROM partidas ORDER BY data_jogo DESC")->fetchAll(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html lang="pt-br">

<head>
    <meta charset="utf-8">
    <title>Pontuar — Admin</title>
    <link rel="stylesheet" href="css/style.css">
</head>

<body>
    <div class="container page--pontuar">
        <div class="page-header">
            <div class="page-title">
                <h1>Pontuar Partidas</h1>
                <p>Defina o placar oficial e atualize os pontos dos participantes</p>
            </div>
            <div class="top-actions">
                <a class="nav-link" href="index.php">🏠 Início</a>
            </div>
        </div>

        <?= $msg ?>

        <?php if (count($partidas) === 0): ?>
            <div class="alert alert--err">Não há partidas cadastradas.</div>
        <?php else: ?>
            <?php foreach ($partidas as $p):
                $data_fmt = $p['data_jogo'] ? date('d/m/Y H:i', strtotime($p['data_jogo'])) : '—';
                $gols_c = isset($p['gols_casa']) && $p['gols_casa'] !== null ? (int)$p['gols_casa'] : '';
                $gols_f = isset($p['gols_fora']) && $p['gols_fora'] !== null ? (int)$p['gols_fora'] : '';
            ?>
                <div class="match-card" style="margin-bottom:12px;">
                    <div class="match-info">
                        <div class="team">
                            <div class="name"><?= esc($p['time_casa']) ?></div>
                            <div class="meta">Casa</div>
                        </div>
                        <div class="vs">
                            <div class="match-date"><?= $data_fmt ?></div>
                        </div>
                        <div class="team" style="align-items:flex-end">
                            <div class="name"><?= esc($p['time_fora']) ?></div>
                            <div class="meta">Fora</div>
                        </div>
                    </div>

                    <div style="min-width:240px;">
                        <form method="post" style="display:flex;gap:8px;align-items:center;">
                            <input type="hidden" name="partida_id" value="<?= $p['id'] ?>">
                            <input type="number" name="gols_casa" class="input-score" min="0" placeholder="Gols Casa" value="<?= $gols_c ?>">
                            <span class="small muted">—</span>
                            <input type="number" name="gols_fora" class="input-score" min="0" placeholder="Gols Fora" value="<?= $gols_f ?>">
                            <button type="submit" class="btn btn-primary">Salvar</button>
                        </form>
                        <div class="helper small muted" style="margin-top:8px;">
                            Atualizando aqui você recalcula pontos das apostas automaticamente.
                        </div>
                    </div>
                </div>
            <?php endforeach; ?>
        <?php endif; ?>

    </div>
</body>

</html>