<?php
include "db.php";

// Define fuso horário do PHP
date_default_timezone_set('America/Sao_Paulo');

$sql = "SELECT a.nome, SUM(p.pontos) as total 
        FROM apostadores a 
        JOIN palpites p ON a.id = p.apostador_id 
        GROUP BY a.id 
        ORDER BY total DESC";
$ranking = $pdo->query($sql)->fetchAll(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html lang="pt-br">

<head>
    <meta charset="UTF-8">
    <title>Ranking</title>
    <link rel="stylesheet" href="css/style.css">
</head>

<body>
    <div class="container page--ranking">
        <div class="page-header">
            <div class="page-title">
                <h1>Ranking</h1>
                <p>Veja a pontuação de todos os apostadores</p>
            </div>
            <div class="top-actions">
                <a class="nav-link" href="index.php">🏠 Início</a>
            </div>
        </div>

        <div class="table-wrap">
            <table>
                <thead>
                    <tr>
                        <th>#</th>
                        <th>Apostador</th>
                        <th>Pontos</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $pos = 1;
                    foreach ($ranking as $r): ?>
                        <tr>
                            <td><span class="rank-badge"><?= $pos++ ?></span></td>
                            <td><span class="name-strong"><?= $r['nome'] ?></span></td>
                            <td><span class="points"><?= $r['total'] ?></span></td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    </div>
</body>

</html>