<?php
session_start();
include "db.php";

// Define fuso horário do PHP
date_default_timezone_set('America/Sao_Paulo');

$msg = "";

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $nome = trim($_POST['nome']);
    $email = trim($_POST['email']);
    $senha = password_hash($_POST['senha'], PASSWORD_DEFAULT);

    try {
        $stmt = $pdo->prepare("INSERT INTO usuarios (nome, email, senha) VALUES (?, ?, ?)");
        $stmt->execute([$nome, $email, $senha]);
        $msg = "<div class='alert alert--ok'>✅ Cadastro realizado com sucesso. <a href='login.php'>Entrar</a></div>";
    } catch (Exception $e) {
        $msg = "<div class='alert alert--err'>⚠️ Email já cadastrado.</div>";
    }
}
?>
<!DOCTYPE html>
<html lang="pt-br">

<head>
    <meta charset="utf-8">
    <title>Registrar — Apostas GreNal</title>
    <link rel="stylesheet" href="css/style.css">
    <style>
        body {
            display: flex;
            align-items: center;
            justify-content: center;
            min-height: 100vh;
            background: linear-gradient(135deg, #1d3557, #457b9d);
            font-family: 'Segoe UI', sans-serif;
        }

        .register-card {
            background: #fff;
            padding: 2rem;
            border-radius: 16px;
            box-shadow: 0 8px 24px rgba(0, 0, 0, 0.2);
            width: 100%;
            max-width: 400px;
            animation: fadeIn 0.8s ease;
        }

        .register-card h1 {
            text-align: center;
            margin-bottom: 0.5rem;
            font-size: 1.8rem;
            color: #1d3557;
        }

        .register-card p {
            text-align: center;
            margin-bottom: 1.5rem;
            color: #6c757d;
            font-size: 0.9rem;
        }

        .register-card .form-field {
            margin-bottom: 1.2rem;
        }

        .register-card label {
            font-size: 0.85rem;
            color: #333;
            display: block;
            margin-bottom: 0.3rem;
        }

        .register-card input {
            width: 100%;
            padding: 0.8rem;
            border-radius: 8px;
            border: 1px solid #ccc;
            font-size: 1rem;
        }

        .register-card input:focus {
            outline: none;
            border-color: #457b9d;
            box-shadow: 0 0 0 3px rgba(69, 123, 157, 0.2);
        }

        .register-card button {
            width: 100%;
            padding: 0.9rem;
            border: none;
            border-radius: 8px;
            background: #1d3557;
            color: #fff;
            font-size: 1rem;
            font-weight: bold;
            cursor: pointer;
            transition: background 0.3s;
        }

        .register-card button:hover {
            background: #457b9d;
        }

        .register-footer {
            text-align: center;
            margin-top: 1rem;
            font-size: 0.9rem;
        }

        .register-footer a {
            color: #1d3557;
            font-weight: bold;
            text-decoration: none;
        }

        .register-footer a:hover {
            text-decoration: underline;
        }

        @keyframes fadeIn {
            from {
                opacity: 0;
                transform: translateY(-20px);
            }

            to {
                opacity: 1;
                transform: translateY(0);
            }
        }
    </style>
</head>

<body>
    <div class="register-card">
        <h1>✍️ Registrar</h1>
        <p>Crie sua conta para apostar nas partidas</p>

        <?= $msg ?>

        <form method="post">
            <div class="form-field">
                <label for="nome">Nome</label>
                <input type="text" name="nome" id="nome" required placeholder="Seu nome completo">
            </div>
            <div class="form-field">
                <label for="email">E-mail</label>
                <input type="email" name="email" id="email" required placeholder="seu@email.com">
            </div>
            <div class="form-field">
                <label for="senha">Senha</label>
                <input type="password" name="senha" id="senha" required placeholder="••••••••">
            </div>
            <button type="submit">Cadastrar</button>
        </form>

        <div class="register-footer">
            <p>Já tem conta? <a href="login.php">Entrar</a></p>
        </div>
    </div>
</body>

</html>