<?php
session_start();
include "db.php";
date_default_timezone_set('America/Sao_Paulo');

if (empty($_SESSION['user_id'])) {
    header('Location: login.php');
    exit;
}

function esc($v)
{
    return htmlspecialchars($v ?? '', ENT_QUOTES, 'UTF-8');
}

$user_id = $_SESSION['user_id'];

// filtros
$filtro_partida = $_GET['partida'] ?? '';
$filtro_usuario = $_GET['usuario'] ?? '';

// consulta apostas
$where = "1=1";
$params = [];

// filtro por partida
if ($filtro_partida) {
    $where .= " AND apostas.partida_id = ?";
    $params[] = $filtro_partida;
}
// filtro por usuário
if ($filtro_usuario) {
    $where .= " AND usuarios.id = ?";
    $params[] = $filtro_usuario;
}

// regra: mostrar sempre apostas do usuário logado
// e apostas de outros apenas se o fechamento já ocorreu
$where .= " AND (usuarios.id = ? OR partidas.fechamento <= NOW())";
$params[] = $user_id;

$sql = "SELECT apostas.id AS aposta_id, usuarios.nome AS usuario, partidas.time_casa, partidas.time_fora,
        partidas.data_jogo, partidas.fechamento, apostas.gols_casa, apostas.gols_fora, apostas.pontos, usuarios.id AS usuario_id
        FROM apostas
        INNER JOIN usuarios ON apostas.usuario_id = usuarios.id
        INNER JOIN partidas ON apostas.partida_id = partidas.id
        WHERE $where
        ORDER BY partidas.data_jogo DESC, usuarios.nome ASC";

$stm = $pdo->prepare($sql);
$stm->execute($params);
$apostas = $stm->fetchAll(PDO::FETCH_ASSOC);

// listas de filtro
$usuarios = $pdo->query("SELECT id, nome FROM usuarios ORDER BY nome")->fetchAll(PDO::FETCH_ASSOC);
$partidas_list = $pdo->query("SELECT * FROM partidas ORDER BY data_jogo DESC")->fetchAll(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html lang="pt-br">

<head>
    <meta charset="UTF-8">
    <title>Ver Apostas — GreNal</title>
    <link rel="stylesheet" href="css/style.css">
    <style>
        body {
            font-family: 'Segoe UI', sans-serif;
            background: linear-gradient(135deg, #1d3557, #457b9d);
            margin: 0;
            padding: 40px 0;
            display: flex;
            justify-content: center;
        }

        .card {
            background: #fff;
            border-radius: 16px;
            padding: 2rem;
            width: 100%;
            max-width: 1000px;
            box-shadow: 0 8px 24px rgba(0, 0, 0, 0.2);
        }

        h1 {
            text-align: center;
            color: #1d3557;
            margin-bottom: 1rem;
        }

        .filters {
            display: flex;
            gap: 1rem;
            flex-wrap: wrap;
            margin-bottom: 1rem;
            justify-content: center;
        }

        .filters select,
        .filters button {
            padding: 0.6rem;
            border-radius: 8px;
            border: 1px solid #ccc;
            font-size: 1rem;
        }

        .filters button {
            border: none;
            background: #1d3557;
            color: #fff;
            cursor: pointer;
        }

        .filters button:hover {
            background: #457b9d;
        }

        .table-container {
            overflow-x: auto;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 1rem;
        }

        th,
        td {
            padding: 0.6rem 0.8rem;
            border-bottom: 1px solid #eee;
            text-align: center;
        }

        th {
            background: #f1f1f1;
            color: #333;
        }

        td {
            color: #333;
        }

        .status-aberta {
            color: #e63946;
            font-weight: bold;
        }

        .status-encerrada {
            color: #2a9d8f;
            font-weight: bold;
        }

        .top-actions {
            text-align: center;
            margin-bottom: 1rem;
        }

        .top-actions a {
            display: inline-block;
            color: #1d3557;
            font-weight: bold;
            text-decoration: none;
            margin: 0 0.5rem;
        }

        .top-actions a:hover {
            text-decoration: underline;
        }
    </style>
</head>

<body>
    <div class="card">
        <div class="top-actions">
            <a href="index.php">🏠 Início</a>
        </div>

        <h1>📊 Apostas de Todos</h1>

        <form method="get" class="filters">
            <select name="partida">
                <option value="">Todas as partidas</option>
                <?php foreach ($partidas_list as $p): ?>
                    <option value="<?= $p['id'] ?>" <?= ($filtro_partida == $p['id']) ? 'selected' : '' ?>>
                        <?= esc($p['time_casa']) ?> x <?= esc($p['time_fora']) ?>
                    </option>
                <?php endforeach; ?>
            </select>
            <select name="usuario">
                <option value="">Todos os usuários</option>
                <?php foreach ($usuarios as $u): ?>
                    <option value="<?= $u['id'] ?>" <?= ($filtro_usuario == $u['id']) ? 'selected' : '' ?>>
                        <?= esc($u['nome']) ?>
                    </option>
                <?php endforeach; ?>
            </select>
            <button type="submit">Filtrar</button>
        </form>

        <div class="table-container">
            <table>
                <thead>
                    <tr>
                        <th>Partida</th>
                        <th>Data do Jogo</th>
                        <th>Usuário</th>
                        <th>Palpite</th>
                        <th>Status</th>
                        <th>Pontos</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if (count($apostas) === 0): ?>
                        <tr>
                            <td colspan="6">Nenhuma aposta encontrada para os filtros selecionados.</td>
                        </tr>
                    <?php else: ?>
                        <?php foreach ($apostas as $a):
                            $data_jogo = date('d/m/Y H:i', strtotime($a['data_jogo']));
                            $status = (strtotime($a['fechamento']) > time()) ? 'Aberta' : 'Encerrada';
                            $status_class = $status === 'Aberta' ? 'status-aberta' : 'status-encerrada';

                            // se for aposta de outro usuário e ainda estiver aberta → oculta placar
                            $palpite = ($a['usuario_id'] == $user_id || $status === 'Encerrada')
                                ? esc($a['gols_casa'] ?? '-') . " — " . esc($a['gols_fora'] ?? '-')
                                : "🔒 Oculto";
                        ?>
                            <tr>
                                <td><?= esc($a['time_casa']) ?> x <?= esc($a['time_fora']) ?></td>
                                <td><?= $data_jogo ?></td>
                                <td><?= esc($a['usuario']) ?></td>
                                <td><?= $palpite ?></td>
                                <td class="<?= $status_class ?>"><?= $status ?></td>
                                <td><?= esc($a['pontos'] ?? 0) ?></td>
                            </tr>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</body>

</html>